window.addEventListener("load", () => {
  const baseURL = "../assets/images/activities/";

  const carouselData = [
    {
      title: "",
      img: "activity25.jpg",
      date_time: "April - May",
      year: 2024,
    },
    {
      title: "",
      img: "activity24.jpg",
      date_time: "April - May",
      year: 2024,
    },
    {
      title: "",
      img: "activity23.jpg",
      date_time: "April - May",
      year: 2024,
    },
    {
      title: "",
      img: "activity22.jpg",
      date_time: "April - May",
      year: 2024,
    },
    {
      title: "",
      img: "activity21.jpg",
      date_time: "April - May",
      year: 2024,
    },
    {
      title: "",
      img: "activity20.jpg",
      date_time: "April - May",
      year: 2024,
    },
    {
      title: "",
      img: "activity19.jpg",
      date_time: "April - May",
      year: 2024,
    },
    {
    title: "",
    img: "activity27.jpg",
    date_time: "March",
    year: 2024,
  },
  {
    title: "",
    img: "activity26.jpg",
    date_time: "March",
    year: 2024,
  },
    {
      title: "Pre-Interview Training",
      img: "activity18.jpg",
      date_time: "December",
      year: 2022,
    },
    {
      title: "Pre-Interview Training",
      img: "activity17.jpg",
      date_time: "December",
      year: 2022,
    },
    {
      title: "Pre-Interview Training",
      img: "activity18.jpg",
      date_time: "December",
      year: 2022,
    },
    {
      title: "Kathina robe-offering ceremony",
      img: "activity16.jpg",
      date_time: "November",
      year: 2022,
    },
    {
      title: "Kathina robe-offering ceremony",
      img: "activity15.jpg",
      date_time: "November",
      year: 2022,
    },
    {
      title: " ",
      img: "activity12.jpg",
      date_time: "January",
      year: 2023,
    },
    {
      title: "",
      img: "activity13.jpg",
      date_time: "September",
      year: 2023,
    },
    {
      title: "",
      img: "activity14.jpg",
      date_time: "September",
      year: 2023,
    },
    {
      title: "Interview with the CEO",
      img: "activity2.jpeg",
      date_time: "December",
      year: 2017,
    },

    {
      title: "Japan Myanmar Seda Event",
      img: "activity3.jpg",
      date_time: "February",
      year: 2019,
    },
    {
      title: "Graduation Ceremony",
      img: "activity4.jpeg",
      date_time: "March",
      year: 2016,
    },
    {
      title: "Business Counseling Activity",
      img: "activity5.jpeg",
      date_time: "August",
      year: 2018,
    },
    {
      title: "CSR Activity",
      img: "activity6.jpeg",
      date_time: "November",
      year: 2015,
    },
    {
      title: "Overseas Employment Activity",
      img: "activity7.jpeg",
      date_time: "July",
      year: 2019,
    },
    {
      title: "Advertising Activity",
      img: "activity8.jpeg",
      date_time: "May",
      year: 2015,
    },
    {
      title: "Anniversary Event",
      img: "activity9.jpg",
      date_time: "September",
      year: 2019,
    },
    {
      title: "Economic Event",
      img: "activity10.jpeg",
      date_time: "April",
      year: 2017,
    },
    {
      title: "CSR Activity",
      img: "activity11.jpeg",
      date_time: "October",
      year: 2015,
    },
  ];

  const curYear = document.querySelector(".current_year_btn");
  const lastYear = document.querySelector(".last_year_btn");
  const lastTwoOrBelow = document.querySelector(".last_two_over_year_btn");
  const yearBtnWrapper = document.querySelectorAll(".year_btn");
  const galleryImageContainer = document.querySelector(
    ".gallery_images_container"
  );

  const actualYear = new Date().getFullYear();

  curYear.innerHTML = actualYear;
  curYear.setAttribute("data-year", actualYear);
  lastYear.innerHTML = actualYear - 1;
  lastYear.setAttribute("data-year", actualYear - 1);
  lastTwoOrBelow.innerHTML = `${actualYear - 2} & Before`;
  lastTwoOrBelow.setAttribute("data-year", actualYear - 2);

  const getCurrentYearData = carouselData.filter((d) => d.year === actualYear);

  yearBtnWrapper.forEach((btn) => {
    btn.addEventListener("click", (e) => {
      page_number = 1; // re-assign the pagination number

      //show the data of the last two year and below
      activYearBtn(Number(e.target.getAttribute("data-year")));

      if (e.target.className.split(" ").includes("last_two_over_year_btn")) {
        const data = carouselData
          .filter((d) => d.year <= Number(e.target.getAttribute("data-year")))
          .sort((a, b) => b.year - a.year);

        btn.classList.add("active");
        showDynamicUI(data);
      } else {
        const data = carouselData.filter(
          (d) => d.year === Number(e.target.getAttribute("data-year"))
        );
        btn.classList.add("active");
        showDynamicUI(data);
      }
    });

    function activYearBtn(num) {
      yearBtnWrapper.forEach((d) => {
        if (Number(d.textContent) === num) {
          d.classList.add("active");
        } else {
          d.classList.remove("active");
        }
      });
    }
  });

  var page_number = 1;

  function showDynamicUI(data) {
    const paginationContainer = document.querySelector(
      ".pagination_btn_container"
    );
    paginationContainer.innerHTML = "";
    if (data.length <= 0) {
      galleryImageContainer.innerHTML = `<p>Activities did not show up</p>`;
    } else {
      //paginated area
      const page_size = 4;
      // grab the pagination btn

      const totalPage = Math.ceil(data.length / page_size);

      if (totalPage <= 1) {
        paginationContainer.innerHTML = "";
      } else {
        paginationContainer.innerHTML = `<button class="next_prev_btn paginate_prev_btn">
        <i class="fa fa-angle-left"></i>
        </button>`;

        Array.from({ length: totalPage }).map((_, idx) => {
          paginationContainer.innerHTML += `<button class="paginate_btn">${
            idx + 1
          }</button>`;
        });

        paginationContainer.innerHTML += `<button class="next_prev_btn paginate_next_btn">
        <i class="fa fa-angle-right"></i></button>`;
      }

      const nextBtn = document.querySelector(".paginate_next_btn");
      const prevBtn = document.querySelector(".paginate_prev_btn");

      if (nextBtn && prevBtn) {
        if (page_number > totalPage) {
          nextBtn.setAttribute("disable", true);
          page_number = 1;
        }
        if (page_number < 1) {
          prevBtn.setAttribute("disable", true);
          page_number = totalPage;
        }

        nextBtn.addEventListener("click", () => {
          page_number++;
          showDynamicUI(data);
        });
        prevBtn.addEventListener("click", () => {
          page_number--;
          showDynamicUI(data);
        });
      }

      const pagiBtns = document.querySelectorAll(".paginate_btn");

      showFilterUI(FilterData(data, page_number, page_size));

      pagiBtns.forEach((btn) => {
        activePaginBtn(page_number);

        btn.addEventListener("click", (e) => {
          page_number = Number(e.target.textContent);
          activeBtnReplace(page_number, totalPage);

          activePaginBtn(page_number);

          const filterData = FilterData(data, page_number, page_size);
          // show filter ui
          showFilterUI(filterData);
        });
      });

      // btn slicing
      function activeBtnReplace(curBtnNum, totalPage) {
        pagiBtns.forEach((cur, idx) => {
          switch (curBtnNum) {
            case 1:
              if (
                curBtnNum - 1 === idx ||
                curBtnNum === idx ||
                curBtnNum + 1 === idx
              ) {
                cur.classList.add("btn_show");
              } else {
                cur.classList.remove("btn_show");
              }
              break;
            case totalPage:
              if (
                curBtnNum - 1 === idx ||
                curBtnNum - 2 === idx ||
                curBtnNum - 3 === idx
              ) {
                cur.classList.add("btn_show");
              } else {
                cur.classList.remove("btn_show");
              }
              break;
            default:
              if (
                curBtnNum - 1 === idx ||
                curBtnNum - 2 === idx ||
                curBtnNum === idx
              ) {
                cur.classList.add("btn_show");
              } else {
                cur.classList.remove("btn_show");
              }
              break;
          }
        });
      }
      activeBtnReplace(page_number, totalPage);

      function activePaginBtn(num) {
        pagiBtns.forEach((d) => {
          if (Number(d.textContent) === num) {
            d.classList.add("active");
          } else {
            d.classList.remove("active");
          }
        });
      }
    }
  }

  showDynamicUI(getCurrentYearData);

  function FilterData(data_array, page_number, page_size) {
    return data_array.slice(
      (page_number - 1) * page_size,
      page_number * page_size
    );
  }

  function showFilterUI(filterData) {
    galleryImageContainer.innerHTML = "";
    for (let i = 0; i < filterData.length; i++) {
      galleryImageContainer.innerHTML += `
    <div class="activites">
    <img src="${baseURL}${filterData[i].img}" />
  
    <div class="activities_desc">
      <h4 class="fs-5">${filterData[i].title}</h4>
      <p>${filterData[i].date_time} ${filterData[i].year}</p>
    </div>
    </div>
    `;
    }
  }
});
